/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.Rectangle;

public class Group extends Composite {
	String text = "";

public Group (Composite parent, int style) {
	super (parent, checkStyle (style));
}

static int checkStyle (int style) {
	style |= SWT.NO_FOCUS;
	/*
	* Even though it is legal to create this widget
	* with scroll bars, they serve no useful purpose
	* because they do not automatically scroll the
	* widget's client area.  The fix is to clear
	* the SWT style.
	*/
	return style & ~(SWT.H_SCROLL | SWT.V_SCROLL);
}

protected void checkSubclass () {
	if (!isValidSubclass ()) error (SWT.ERROR_INVALID_SUBCLASS);
}

public String getText () {
	checkWidget ();
	return text;
}

public void setText (String string) {
	checkWidget ();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	text = string;
	_setText (string);
}

/*---------------------- COMMON INTERFACE -------------------*/

//TODO IMPORTANT: fix _computeTrim, _getClientArea and setWidgetVounds to not using hardcoded values (3,10,13, etc..)

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.Group"]){
		$wnd.dojo._hasResource["org.eclipse.swt.Group"] = true;
		$wnd.dojo.provide("org.eclipse.swt.Group");
		
		$wnd.dojo.require("org.eclipse.swt.Composite");
		$wnd.dojo.require("dijit._Templated");
		
		$wnd.dojo.declare(
			"org.eclipse.swt.Group", $wnd.eval("[org.eclipse.swt.Composite, dijit._Templated]"),{
				title: "",
				baseClass: "swtGroup",
				templateString: "<div class='${baseClass} swtComposite' baseClass='${baseClass}'>" +
									"<div class='${baseClass}Title' dojoAttachPoint='titleNode'>${title}</div>" +
									"<div class='${baseClass}Container' dojoAttachPoint='iconNode'></div>" +
								"</div>",				
				setTitle: function(title){
					this.titleNode.innerHTML = title;					
				},
				setWidgetBounds: function(dim){
					$wnd.swt.setBounds(this.domNode, dim);
//TODO Implement without hardcoded margins					
					$wnd.swt.setBounds(this.iconNode,{t:6,l:0,w:dim.w,h:dim.h-6});
				}
			}
		);
	}
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var params = {};
	var self = new $wnd.org.eclipse.swt.Group(params);
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

//TODO Implement without hardcoded margins
Rectangle _computeTrim (int x, int y, int width, int height) {
	return new Rectangle(x+1,y+1,width+1,height+14);
}

//TODO Implement without hardcoded margins
native void _getClientArea (Rectangle rectangle) /*-{
	var dim = $wnd.swt.getNativeSize(this.@org.eclipse.swt.widgets.Widget::jsObject.domNode, true);
	rectangle.@org.eclipse.swt.graphics.Rectangle::x = 3;
	rectangle.@org.eclipse.swt.graphics.Rectangle::y = 8;
	rectangle.@org.eclipse.swt.graphics.Rectangle::width = dim.w-3;
	rectangle.@org.eclipse.swt.graphics.Rectangle::height = dim.h-8;
}-*/;

native void _setText (String string) /*-{	
	this.@org.eclipse.swt.widgets.Widget::jsObject.setTitle(string);
}-*/;

}
